import { View, FlatList, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";

const RenderItem = ({ item }) => {
    return (
        <View style={styles.itemCont}>
            <SkeletonElement wrapperStyle={styles.wrapperStyle} />
        </View>
    );
};

const RecentSearchSkeleton = () => {
    return (
        <FlatList
            data={[1, 2, 3, 4, 5]}
            keyExtractor={(_, i) => "key" + i}
            listKey={(_, i) => `listKey-A${i}`}
            renderItem={({ item }) => <RenderItem item={item} />}
            showsVerticalScrollIndicator={false}
        />
    );
};

export default RecentSearchSkeleton;

const styles = StyleSheet.create({
    itemCont: {
        marginTop: dpr(10),
    },
    wrapperStyle: {
        height: dpr(12),
        width: dpr(200),
    }
});
